struct skinHelper
(
	rootBone = undefined,
	sortedBoneList = #(),
	boneList = #(),

	tab = 0,
	fn doTab n =
	(
		local strTab = ""
		for i = 1 to n do strTab += "\t"
		return strTab
	),

	fn findBoneByName list boneName =
	(
		for nBone = 1 to list.count do
		(
			if list[nBone].name == boneName do return nBone
		)

		return 0
	),

	fn getRootBone =
	(
		--format "Getting rootbone: %\n" boneList.count
		for b in boneList do
		(
			--format "bone: %\t%\n" b b.parent
			
			if b.parent == undefined do
				--return b.parent
				return b
		)
		
		return undefined
	),

	fn sortBones b =
	(
		if ((findBoneByName boneList b.name) != 0) or (b == rootBone) do
		(
			--format "%\n" ((doTab tab) + b.name)

			append sortedBoneList b

			--tab += 1
			for child in b.children do sortBones child
			--tab -= 1
		)
	),

	fn init nodeList =
	(
		-- Loop through node list, collecting existing bones
		for auxNode in nodeList do
		(
			-- TODO: tenemos que seleccionar el modificador skin primero

			-- Set modify mode
			max modify mode
			-- Reference to the skin modifier for this mesh
			skinMod = auxNode.modifiers[#Skin]
			-- Look if the skin modifier exists
			if skinMod == undefined do
			(
				local msg = stringStream ""
				format "ERROR!: no skin modifier for \"%\"" auxNode.name to: msg
				messageBox (msg as String) title: ".::MD5Exporter::."
				close msg
				return false
			)
			-- Set skin as current modifier
			modPanel.setCurrentObject skinMod

			-- Number of bones for the current node
			numBones = skinOps.getNumberBones skinMod
	
			-- Retrieve the *unsorted* list of bones
			for b = 1 to numBones do
			(
				local bName = skinOps.getBoneName skinMod b 1
				local bNode = getNodeByName bName

				-- Append the bone to the list if it's not already there
				if (findBoneByName boneList bName) == 0 do
					append boneList bNode
			)
		)

		--for b in boneList do format "bone: %\tparent: %\n" b.name b.parent.name

		-- Get the root bone
		rootBone = getRootBone()
		
		format "rootbone: %\n" rootBone

		-- Sort de list of bones
		sortBones rootBone
		
		return true
	)
)